/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RefineHandler {
    private static final ResourceLocation REFINE = new ResourceLocation("slashblade", "tips/refine");
    private static final TagKey<Item> soul = ItemTags.create((ResourceLocation)new ResourceLocation("slashblade", "proudsouls"));

    public static RefineHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RefineHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        int cost;
        if (!event.getOutput().m_41619_()) {
            return;
        }
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.m_41619_()) {
            return;
        }
        if (!(base.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int level = material.getEnchantmentValue();
        if (level < 0) {
            return;
        }
        ItemStack result = base.m_41777_();
        int refineLimit = Math.max(10, level);
        for (cost = 0; cost < material.m_41613_(); ++cost) {
            float damage = result.getCapability(ItemSlashBlade.BLADESTATE).map(s -> {
                s.setDamage(s.getDamage() - (0.2f + 0.05f * (float)level));
                if (s.getRefine() < refineLimit) {
                    s.setRefine(s.getRefine() + 1);
                }
                return Float.valueOf(s.getDamage());
            }).orElse(Float.valueOf(0.0f)).floatValue();
            if (!(damage <= 0.0f)) continue;
            break;
        }
        event.setMaterialCost(cost);
        int levelCostBase = 1;
        event.setCost(levelCostBase * cost);
        event.setOutput(result);
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        int after;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack material = event.getRight();
        ItemStack base = event.getLeft();
        ItemStack output = event.getOutput();
        if (base.m_41619_()) {
            return;
        }
        if (!(base.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int before = base.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.getRefine()).orElse(0);
        if (before < (after = output.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.getRefine()).orElse(0).intValue())) {
            AdvancementHelper.grantCriterion((ServerPlayer)event.getEntity(), REFINE);
        }
    }

    private static final class SingletonHolder {
        private static final RefineHandler instance = new RefineHandler();

        private SingletonHolder() {
        }
    }
}

